<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="fn xs xsi xsl">
	<xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>
	<xsl:decimal-format name="decimal" decimal-separator="."/>
	<xsl:template match="/iva">
		<iva>
			<numeroRuc>
				<xsl:value-of select="numeroRuc"/>
			</numeroRuc>
			<razonSocial>
				<xsl:value-of select="razonSocial"/>
			</razonSocial>
			<anio>
				<xsl:value-of select="anio"/>
			</anio>
			<mes>
				<xsl:value-of select="mes"/>
			</mes>
			<xsl:if test="compras">
				<compras>
					<xsl:for-each select="compras/detalleCompras">
						<detalleCompras>
							<codSustento>
								<xsl:value-of select="codSustento"/>
							</codSustento>
							<tpIdProv>
								<xsl:value-of select="tpIdProv"/>
							</tpIdProv>
							<idProv>
								<xsl:value-of select="idProv"/>
							</idProv>
							<tipoComprobante>
								<xsl:value-of select="tipoComprobante"/>
							</tipoComprobante>
							<fechaRegistro>
								<xsl:value-of select="fechaRegistro"/>
							</fechaRegistro>
							<establecimiento>
								<xsl:value-of select="establecimiento"/>
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision"/>
							</puntoEmision>
							<secuencial>
								<xsl:value-of select="secuencial"/>
							</secuencial>
							<fechaEmision>
								<xsl:value-of select="fechaEmision"/>
							</fechaEmision>
							<autorizacion>
								<xsl:value-of select="autorizacion"/>
							</autorizacion>
							<baseNoGraIva>
								<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
								<xsl:value-of select="string('0.00')" />
							</baseNoGraIva>
							<baseImponible>
								<xsl:value-of select="baseImponible"/>
							</baseImponible>
							<baseImpGrav>
								<xsl:value-of select="baseImpGrav"/>
							</baseImpGrav>
							<montoIce>
								<xsl:value-of select="montoIce"/>
							</montoIce>
							<montoIva>
								<xsl:value-of select="montoIva"/>
							</montoIva>
							<xsl:if test="porRetBienes='1'">
								<valorRetBienes>
									<xsl:value-of select="format-number(valorRetBienes, '#0.00', 'decimal')"/>
								</valorRetBienes>
							</xsl:if>
							<xsl:if test="porRetBienes!='1'">
								<valorRetBienes>
									<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
									<xsl:value-of select="string('0.00')" />
								</valorRetBienes>
							</xsl:if>
							<xsl:if test="porRetServicios='2' or porRetServicios='4'">
								<valorRetServicios>
									<xsl:value-of select="format-number(valorRetServicios, '#0.00', 'decimal')"/>
								</valorRetServicios>
							</xsl:if>
							<xsl:if test="porRetServicios!='2' and porRetServicios!='4'">
								<valorRetServicios>
									<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
									<xsl:value-of select="string('0.00')" />
								</valorRetServicios>
							</xsl:if>
							<xsl:if test="porRetBienes='3' and porRetServicios='3'">
								<valRetServ100>
									<xsl:value-of select="format-number(valorRetBienes + valorRetServicios, '#0.00', 'decimal')"/>
								</valRetServ100>
							</xsl:if>
							<xsl:if test="porRetBienes='3' and porRetServicios!='3'">
								<valRetServ100>
									<xsl:value-of select="format-number(valorRetBienes, '#0.00', 'decimal')"/>
								</valRetServ100>
							</xsl:if>
							<xsl:if test="porRetBienes!='3' and porRetServicios='3'">
								<valRetServ100>
									<xsl:value-of select="format-number(valorRetServicios, '#0.00', 'decimal')"/>
								</valRetServ100>
							</xsl:if>
							<xsl:if test="porRetBienes!='3' and porRetServicios!='3'">
								<valRetServ100>
									<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
									<xsl:value-of select="string('0.00')" />
								</valRetServ100>
							</xsl:if>
							<xsl:if test="air">
								<air>
									<xsl:for-each select="air/detalleAir">
										<detalleAir>
											<codRetAir>
												<xsl:value-of select="codRetAir"/>
											</codRetAir>
											<baseImpAir>
												<xsl:value-of select="baseImpAir"/>
											</baseImpAir>
											<porcentajeAir>
												<xsl:value-of select="porcentajeAir"/>
											</porcentajeAir>
											<valRetAir>
												<xsl:value-of select="valRetAir"/>
											</valRetAir>
										</detalleAir>
									</xsl:for-each>
								</air>
							</xsl:if>
							
							<!-- se reemplaza por una mejor forma de importar 
							<xsl:if test="estabRetencion1!='000'">
								<estabRetencion1>
									<xsl:value-of select="estabRetencion1"/>
								</estabRetencion1>
							</xsl:if>
							<xsl:if test="ptoEmiRetencion1!='000'">
								<ptoEmiRetencion1>
									<xsl:value-of select="ptoEmiRetencion1"/>
								</ptoEmiRetencion1>
							</xsl:if>
							<xsl:if test="secRetencion1!='0'">
								<secRetencion1>
									<xsl:value-of select="secRetencion1"/>
								</secRetencion1>
							</xsl:if>
							<xsl:if test="autRetencion1!='000'">
								<autRetencion1>
									<xsl:value-of select="autRetencion1"/>
								</autRetencion1>
							</xsl:if>
							<xsl:if test="fechaEmiRet1!='00/00/0000'">
								<fechaEmiRet1>
									<xsl:value-of select="fechaEmiRet1"/>
								</fechaEmiRet1>
							</xsl:if>
							 -->
							
							<xsl:if test="estabRetencion1">
								<xsl:if test="not(estabRetencion1 = '000')">
									<estabRetencion1>
										<xsl:value-of select="estabRetencion1" />
									</estabRetencion1>

									<ptoEmiRetencion1>
										<xsl:value-of select="ptoEmiRetencion1" />
									</ptoEmiRetencion1>

									<secRetencion1>
										<xsl:value-of select="secRetencion1" />
									</secRetencion1>

									<autRetencion1>
										<xsl:value-of select="autRetencion1" />
									</autRetencion1>

									<xsl:if test="not(fechaEmiRet1 = '00/00/0000')">
										<fechaEmiRet1>
											<xsl:value-of select="fechaEmiRet1" />
										</fechaEmiRet1>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							
							<!-- valores q desaparecen en la nueva version
							<xsl:if test="estabRetencion2!='000'">
								<estabRetencion2>
									<xsl:value-of select="estabRetencion2"/>
								</estabRetencion2>
							</xsl:if>
							<xsl:if test="ptoEmiRetencion2!='000'">
								<ptoEmiRetencion2>
									<xsl:value-of select="ptoEmiRetencion2"/>
								</ptoEmiRetencion2>
							</xsl:if>
							<xsl:if test="secRetencion2!='0'">
								<secRetencion2>
									<xsl:value-of select="secRetencion2"/>
								</secRetencion2>
							</xsl:if>
							<xsl:if test="autRetencion2!='000'">
								<autRetencion2>
									<xsl:value-of select="autRetencion2"/>
								</autRetencion2>
							</xsl:if>
							<xsl:if test="fechaEmiRet2!='00/00/0000'">
								<fechaEmiRet2>
									<xsl:value-of select="fechaEmiRet2"/>
								</fechaEmiRet2>
							</xsl:if>
							 -->
							
							<!-- se reemplaza por una mejor forma de importar 
							<docModificado>
								<xsl:value-of select="docModificado"/>
							</docModificado>
							<estabModificado>
								<xsl:value-of select="estabModificado"/>
							</estabModificado>
							<ptoEmiModificado>
								<xsl:value-of select="ptoEmiModificado"/>
							</ptoEmiModificado>
							<secModificado>
								<xsl:value-of select="secModificado"/>
							</secModificado>
							<autModificado>
								<xsl:value-of select="autModificado"/>
							</autModificado>
							-->
							
							<xsl:if test="docModificado">
								<xsl:if test="number(docModificado) > 0">
									<docModificado>
										<xsl:choose>
											<xsl:when test="string-length(docModificado) = 1">
												<xsl:value-of select="concat('0',docModificado)" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="docModificado" />
											</xsl:otherwise>
										</xsl:choose>
									</docModificado>

									<estabModificado>
										<xsl:value-of select="estabModificado" />
									</estabModificado>

									<ptoEmiModificado>
										<xsl:value-of select="ptoEmiModificado" />
									</ptoEmiModificado>

									<secModificado>
										<xsl:value-of select="secModificado" />
									</secModificado>

									<autModificado>
										<xsl:value-of select="autModificado" />
									</autModificado>
								</xsl:if>
							</xsl:if>
							
						</detalleCompras>
					</xsl:for-each>
				</compras>
			</xsl:if>
			<xsl:if test="ventas">
				<ventas>
					<xsl:for-each select="ventas/detalleVentas">
						<detalleVentas>
							<tpIdCliente>
								<xsl:value-of select="tpIdCliente"/>
							</tpIdCliente>
							<idCliente>
								<xsl:value-of select="idCliente"/>
							</idCliente>
							<tipoComprobante>
								<xsl:value-of select="tipoComprobante"/>
							</tipoComprobante>
							<numeroComprobantes>
								<xsl:value-of select="numeroComprobantes"/>
							</numeroComprobantes>
							<baseNoGraIva>
								<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
								<xsl:value-of select="string('0.00')" />
							</baseNoGraIva>
							<baseImponible>
								<xsl:value-of select="baseImponible"/>
							</baseImponible>
							<baseImpGrav>
								<xsl:value-of select="baseImpGrav"/>
							</baseImpGrav>
							<montoIva>
								<xsl:value-of select="montoIva"/>
							</montoIva>
							<montoIce>
								<xsl:value-of select="montoIce"/>
							</montoIce>
							<valorRetIva>
								<xsl:value-of select="format-number(valorRetBienes + valorRetServicios, '#0.00', 'decimal')"/>
							</valorRetIva>
							<valorRetRenta>
								<xsl:value-of select="format-number(sum(air/detalleAir/valRetAir), '#0.00', 'decimal')"/>
							</valorRetRenta>
						</detalleVentas>
					</xsl:for-each>
				</ventas>
			</xsl:if>
			<xsl:if test="exportaciones">
				<exportaciones>
					<xsl:for-each select="exportaciones/detalleExportaciones">
						<detalleExportaciones>
							<exportacionDe>
								<xsl:value-of select="exportacionDe"/>
							</exportacionDe>
							<tipoComprobante>
								<xsl:value-of select="tipoComprobante"/>
							</tipoComprobante>
							<xsl:if test="distAduanero!=''">
								<distAduanero>
									<xsl:value-of select="distAduanero"/>
								</distAduanero>
							</xsl:if>
							<xsl:if test="anio!=''">
								<anio>
									<xsl:value-of select="anio"/>
								</anio>
							</xsl:if>
							<xsl:if test="regimen!=''">
								<regimen>
									<xsl:value-of select="regimen"/>
								</regimen>
							</xsl:if>
							<xsl:if test="correlativo!=''">
								<correlativo>
									<xsl:value-of select="correlativo"/>
								</correlativo>
							</xsl:if>
							<xsl:if test="verificador!=''">
								<verificador>
									<xsl:value-of select="verificador"/>
								</verificador>
							</xsl:if>
							<xsl:if test="docTransp!=''">
								<docTransp>
									<xsl:value-of select="docTransp"/>
								</docTransp>
							</xsl:if>
							<fechaEmbarque>
								<xsl:value-of select="fechaEmbarque"/>
							</fechaEmbarque>
							<fue>
								<xsl:value-of select="'0000000000000'"/>
							</fue>
							<valorFOB>
								<xsl:value-of select="valorFOB"/>
							</valorFOB>
							<valorFOBComprobante>
								<xsl:value-of select="valorFOBComprobante"/>
							</valorFOBComprobante>
							<establecimiento>
								<xsl:value-of select="establecimiento"/>
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision"/>
							</puntoEmision>
							<secuencial>
								<xsl:value-of select="secuencial"/>
							</secuencial>
							<autorizacion>
								<xsl:value-of select="autorizacion"/>
							</autorizacion>
							<fechaEmision>
								<xsl:value-of select="fechaEmision"/>
							</fechaEmision>
						</detalleExportaciones>
					</xsl:for-each>
				</exportaciones>
			</xsl:if>
			<xsl:if test="recap">
				<recap>
					<xsl:for-each select="recap/detalleRecap">
						<detalleRecap>
							<establecimientoRecap>
								<xsl:value-of select="establecimientoRecap"/>
							</establecimientoRecap>
							<identificacionRecap>
								<xsl:value-of select="identificacionRecap"/>
							</identificacionRecap>
							<tipoComprobante>
								<xsl:value-of select="tipoComprobante"/>
							</tipoComprobante>
							<numeroRecap>
								<xsl:value-of select="numeroRecap"/>
							</numeroRecap>
							<fechaPago>
								<xsl:value-of select="fechaPago"/>
							</fechaPago>
							<tarjetaCredito>
								<xsl:value-of select="tarjetaCredito"/>
							</tarjetaCredito>
							<fechaEmisionRecap>
								<xsl:value-of select="fechaEmisionRecap"/>
							</fechaEmisionRecap>
							<consumoCero>
								<xsl:value-of select="consumoCero"/>
							</consumoCero>
							<consumoGravado>
								<xsl:value-of select="consumoGravado"/>
							</consumoGravado>
							<totalConsumo>
								<xsl:value-of select="totalConsumo"/>
							</totalConsumo>
							<montoIva>
								<xsl:value-of select="montoIva"/>
							</montoIva>
							<comision>
								<xsl:value-of select="comision"/>
							</comision>
							<numeroVouchers>
								<xsl:value-of select="numeroVouchers"/>
							</numeroVouchers>
							<xsl:if test="porRetBienes='1'">
								<valorRetBienes>
									<xsl:value-of select="format-number(valorRetBienes, '#0.00', 'decimal')"/>
								</valorRetBienes>
							</xsl:if>
							<xsl:if test="porRetBienes!='1'">
								<valorRetBienes>
									<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
									<xsl:value-of select="string('0.00')" />
								</valorRetBienes>
							</xsl:if>
							<xsl:if test="porRetServicios='2' or porRetServicios='4'">
								<valorRetServicios>
									<xsl:value-of select="format-number(valorRetServicios, '#0.00', 'decimal')"/>
								</valorRetServicios>
							</xsl:if>
							<xsl:if test="porRetServicios!='2' and porRetServicios!='4'">
								<valorRetServicios>
									<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
									<xsl:value-of select="string('0.00')" />
								</valorRetServicios>
							</xsl:if>
							
							<xsl:if test="porRetBienes='3' and porRetServicios='3'">
								<valRetServ100>
									<xsl:value-of select="format-number(valorRetBienes + valorRetServicios, '#0.00', 'decimal')"/>
								</valRetServ100>
							</xsl:if>
							<xsl:if test="porRetBienes='3' and porRetServicios!='3'">
								<valRetServ100>
									<xsl:value-of select="format-number(valorRetBienes, '#0.00', 'decimal')"/>
								</valRetServ100>
							</xsl:if>
							<xsl:if test="porRetBienes!='3' and porRetServicios='3'">
								<valRetServ100>
									<xsl:value-of select="format-number(valorRetServicios, '#0.00', 'decimal')"/>
								</valRetServ100>
							</xsl:if>
							<xsl:if test="porRetBienes!='3' and porRetServicios!='3'">
								<valRetServ100>
									<!--<xsl:value-of select="format-number(0.00, '#.00', 'decimal')"/>-->
									<xsl:value-of select="string('0.00')" />
								</valRetServ100>
							</xsl:if>
							<xsl:if test="air">
							<air>
								<xsl:for-each select="air/detalleAir">
									<detalleAir>
										<codRetAir>
											<xsl:value-of select="codRetAir"/>
										</codRetAir>
										<baseImpAir>
											<xsl:value-of select="baseImpAir"/>
										</baseImpAir>
										<porcentajeAir>
											<xsl:value-of select="porcentajeAir"/>
										</porcentajeAir>
										<valRetAir>
											<xsl:value-of select="valRetAir"/>
										</valRetAir>
									</detalleAir>
								</xsl:for-each>
							</air>
							</xsl:if>
							<establecimiento>
								<xsl:value-of select="establecimiento"/>
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision"/>
							</puntoEmision>
							<secuencial>
								<xsl:value-of select="secuencial"/>
							</secuencial>
							<autorizacion>
								<xsl:value-of select="autorizacion"/>
							</autorizacion>
							<fechaEmision>
								<xsl:value-of select="fechaEmision"/>
							</fechaEmision>
						</detalleRecap>
					</xsl:for-each>
				</recap>
			</xsl:if>
			<xsl:if test="fideicomisos">
				<fideicomisos>
					<xsl:for-each select="fideicomisos/detalleFideicomisos">
						<detalleFideicomisos>
							<tipoBeneficiario>
								<xsl:value-of select="tipoBeneficiario"/>
							</tipoBeneficiario>
							<idBeneficiario>
								<xsl:value-of select="idBeneficiario"/>
							</idBeneficiario>
							<rucFideicomiso>
								<xsl:value-of select="rucFideicomiso"/>
							</rucFideicomiso>
							<fValor>
								<xsl:for-each select="fValor/detallefValor">
									<detallefValor>
										<tipoFideicomiso>
											<xsl:value-of select="tipoFideicomiso"/>
										</tipoFideicomiso>
										<totalF>
											<xsl:value-of select="totalF"/>
										</totalF>
										<individualF>
											<xsl:value-of select="individualF"/>
										</individualF>
										<porRetF>
											<xsl:value-of select="porRetF"/>
										</porRetF>
										<valorRetF>
											<xsl:value-of select="valorRetF"/>
										</valorRetF>
									</detallefValor>
								</xsl:for-each>
							</fValor>
						</detalleFideicomisos>
					</xsl:for-each>
				</fideicomisos>
			</xsl:if>
			<xsl:if test="anulados">
				<anulados>
					<xsl:for-each select="anulados/detalleAnulados">
						<detalleAnulados>
							<tipoComprobante>
								<xsl:value-of select="tipoComprobante"/>
							</tipoComprobante>
							<establecimiento>
								<xsl:value-of select="establecimiento"/>
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision"/>
							</puntoEmision>
							<secuencialInicio>
								<xsl:value-of select="secuencialInicio"/>
							</secuencialInicio>
							<secuencialFin>
								<xsl:value-of select="secuencialFin"/>
							</secuencialFin>
							<autorizacion>
								<xsl:value-of select="autorizacion"/>
							</autorizacion>
						</detalleAnulados>
					</xsl:for-each>
				</anulados>
			</xsl:if>
			<xsl:if test="rendFinancieros">
				<rendFinancieros>
					<xsl:for-each select="rendFinancieros/detalleRendFinancieros">
						<detalleRendFinancieros>
							<retenido>
								<xsl:value-of select="retenido"/>
							</retenido>
							<idRetenido>
								<xsl:value-of select="idRetenido"/>
							</idRetenido>
							<retenciones>
								<detRet>
                  <xsl:if test="estabRetencion">
                    <estabRetencion>
                      <xsl:value-of select="estabRetencion"/>
                    </estabRetencion>
                  </xsl:if>
                  <xsl:if test="not(estabRetencion)">
                    <estabRetencion>
                      <xsl:value-of select="'000'"/>
                    </estabRetencion>
                  </xsl:if>
                  <xsl:if test="ptoEmiRetencion">
                    <ptoEmiRetencion>
                      <xsl:value-of select="ptoEmiRetencion"/>
                    </ptoEmiRetencion>
                  </xsl:if>
                  <xsl:if test="not(ptoEmiRetencion)">
                    <ptoEmiRetencion>
                      <xsl:value-of select="'000'"/>
                    </ptoEmiRetencion>
                  </xsl:if>
                  <xsl:if test="secRetencion">
                    <secRetencion>
                      <xsl:value-of select="secRetencion"/>
                    </secRetencion>
                  </xsl:if>
                  <xsl:if test="not(secRetencion)">
                    <secRetencion>
                      <xsl:value-of select="0"/>
                    </secRetencion>
                  </xsl:if>
                  <xsl:if test="autRetencion">
                    <autRetencion>
                      <xsl:value-of select="autRetencion"/>
                    </autRetencion>
                  </xsl:if>
                  <xsl:if test="not(autRetencion)">
                    <autRetencion>
                      <xsl:value-of select="'000'"/>
                    </autRetencion>
                  </xsl:if>
                  <xsl:if test="fechaEmiRet">
                    <fechaEmiRet>
                      <xsl:value-of select="fechaEmiRet"/>
                    </fechaEmiRet>
                  </xsl:if>
                  <xsl:if test="not(fechaEmiRet)">
                    <fechaEmiRet>
                      <xsl:value-of select="'00/00/0000'"/>
                    </fechaEmiRet>
                  </xsl:if>
                  <xsl:if test="airRend">
                    <airRend>
                      <xsl:for-each select="airRend/detalleAirRen">
                        <detalleAirRen>
                          <codRetAir>
                            <xsl:value-of select="codRetAir"/>
                          </codRetAir>
                          <deposito>
                            <xsl:value-of select="deposito"/>
                          </deposito>
                          <baseImpAir>
                            <xsl:value-of select="baseImpAir"/>
                          </baseImpAir>
                          <porcentajeAir>
                            <xsl:value-of select="porcentajeAir"/>
                          </porcentajeAir>
                          <valRetAir>
                            <xsl:value-of select="valRetAir"/>
                          </valRetAir>
                        </detalleAirRen>
                      </xsl:for-each>
                    </airRend>
                  </xsl:if>
                </detRet>
							</retenciones>
						</detalleRendFinancieros>
					</xsl:for-each>
				</rendFinancieros>
			</xsl:if>
		</iva>
	</xsl:template>
</xsl:stylesheet>
